<script>
$(document).ready( function () {
  function getBase64FromImageUrl(url) {
    var img = new Image();
    img.crossOrigin = "anonymous";
    img.onload = function () {
        var canvas = document.createElement("canvas");
        canvas.width =this.width;
        canvas.height =this.height;
        var ctx = canvas.getContext("2d");
        ctx.drawImage(this, 0, 0);
        var dataURL = canvas.toDataURL("image/png");
        return dataURL.replace(/^data:image\/(png|jpg);base64,/, "");
    };
    img.src = url;
  }
var table = $('#example').DataTable( {
  lengthChange: false,
  buttons: [ 'copy',
  {
    text: 'Cetak',
    extend: 'pdfHtml5',
    filename: 'Rekap Presensi Siswa',
    orientation: 'landscape', //portrait
    pageSize: 'A4', //A3 , A5 , A6 , legal , letter
    exportOptions: {
      columns: ':visible',
      search: 'applied',
      order: 'applied'
    },
    customize: function (doc) {
      //Remove the title created by datatTables
      doc.content.splice(0,1);
      //Create a date string that we use in the footer. Format is dd-mm-yyyy
      var now = new Date();
      var jsDate = now.getDate()+'-'+(now.getMonth()+1)+'-'+now.getFullYear();
      // Logo converted to base64
      // var logo = getBase64FromImageUrl('https://datatables.net/media/images/logo.png');
      // The above call should work, but not when called from codepen.io
      // So we use a online converter and paste the string in.
      // Done on http://codebeautify.org/image-to-base64-converter
      // It's a LONG string scroll down to see the rest of the code !!!
      var logo = 'data:image/jpeg;base64,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';
      // A documentation reference can be found at
      // https://github.com/bpampuch/pdfmake#getting-started
      // Set page margins [left,top,right,bottom] or [horizontal,vertical]
      // or one number for equal spread
      // It's important to create enough space at the top for a header !!!
      doc.pageMargins = [20,110,20,30];
      // Set the font size fot the entire document
      doc.defaultStyle.fontSize = 12;
      // Set the fontsize for the table header
      doc.styles.tableHeader.fontSize = 12;
      // Create a header object with 3 columns
      // Left side: Logo
      // Middle: brandname
      // Right side: A document title
      doc['header']=(function() {
        return {
          columns: [
            {
              image: logo,
              height: 50,
              width: 50
            },
            {
              alignment: 'Right',
              bold: true,
              fontSize: 20,
              text: 'Rekap Presensi Siswa',
              margin: [10,10]
            },
            {
              alignment: 'right',
              text: ['Dibuat Pada Tanggal: ', { text: jsDate.toString() }]
            },
          ],
          margin: 20
        }
      });
      // Create a footer object with 2 columns
      // Left side: report creation date
      // Right side: current page and total pages
      doc['footer']=(function(page, pages) {
        return {
          columns: [
            {
              alignment: 'right',
              text: ['halaman ', { text: page.toString() },	' of ',	{ text: pages.toString() }]
            }
          ],
          margin: 20
        }
      });
      // Change dataTable layout (Table styling)
      // To use predefined layouts uncomment the line below and comment the custom lines below
      // doc.content[0].layout = 'lightHorizontalLines'; // noBorders , headerLineOnly
      var objLayout = {};
      objLayout['hLineWidth'] = function(i) { return .5; };
      objLayout['vLineWidth'] = function(i) { return .5; };
      objLayout['hLineColor'] = function(i) { return '#aaa'; };
      objLayout['vLineColor'] = function(i) { return '#aaa'; };
      objLayout['paddingLeft'] = function(i) { return 4; };
      objLayout['paddingRight'] = function(i) { return 4; };
      doc.content[0].layout = objLayout;
  }
}
],
  dom: 'Bftrip',
    orderCellsTop: false,
    fixedHeader: false
} );
table.buttons().container()
.appendTo( '#example_wrapper .col-md-6:eq(0)' );
} );
</script>
<?php
$no = 1;
$id = @$_GET['id'];

if (@$_SESSION['admin'] || @$_SESSION['pengajar']) { ?>
    <div class="row">
        <div class="col-md-12">
            <h1 class="page-header">Rekap Presensi Siswa</h1>
        </div>
    </div>
<?php
}

if (@$_GET['action'] == '') {
    if (@$_SESSION['admin'] || @$_SESSION['pengajar']) { ?>
        <div class="alert alert-info alert-has-icon">
  <div class="alert-icon"><i class="far fa-lightbulb"></i></div>
  <div class="alert-body">
    <div class="alert-title">Info</div>
    Anda dapat menyalin, mengubah data presensi ke dalam bentuk excel, pdf,csv atau mengeprint secara langsung.
  </div>
</div>
    <?php
    } ?>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                <?php
                if (@$_GET['IDkelas'] == '') {
                } ?>
                </div>
                <div class="panel-body">
                	<div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover" id="example">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>NIS</th>
                                    <th>Nama Lengkap</th>
                                    <th>Kelas</th>
                                    <th>Mapel</th>
                                    <th>Tanggal Presensi</th>
                                    <th>Waktu Presensi</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php

                            if (@$_GET['IDkelas'] == '') {
                                $sql_presensi_siswa = mysqli_query($db, "SELECT * FROM tb_presensi JOIN tb_kelas ON tb_presensi.kelas = tb_kelas.id_kelas JOIN tb_mapel ON tb_mapel.id = tb_presensi.mapel") or die($db->error);
                            }
    if (mysqli_num_rows($sql_presensi_siswa) > 0) {
        while ($data_presensi_siswa = mysqli_fetch_array($sql_presensi_siswa)) { ?>
    	                            <tr>
    	                                <td align="center"><?php echo $no++; ?></td>
    	                                <td><?php echo $data_presensi_siswa['nis']; ?></td>
    	                                <td><?php echo $data_presensi_siswa['nama_lengkap']; ?></td>
    	                                <td><?php echo $data_presensi_siswa['nama_kelas']; ?></td>
    	                                <td><?php echo $data_presensi_siswa['mapel']; ?></td>
                                      <td><?php echo $data_presensi_siswa['tgl_presensi']; ?></td>
        	                            <td><?php echo $data_presensi_siswa['waktu_presensi']; ?></td>
    	                            </tr>
    	                        <?php
                                }
    } else { ?>
    							<tr>
                                    <td colspan="8" align="center">Data tidak ditemukan</td>
    							</tr>
    		                	<?php
                            } ?>
                      </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>

    <?php
} if (@$_GET['action'] == 'hapus') {
                                mysqli_query($db, "DELETE FROM tb_presensi WHERE id_siswa = '$id'") or die($db->error);
                                echo "<script>window.location='?page=rekappresensisiswa';</script>"; ?>
<?php
                            }
